/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.printer;

import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.gprinter.model.DataInfoModel;
import com.gprinter.model.DeviceInfoModel;
import com.gprinter.save.PortParamDataBase;
import com.gprinter.service.GpPrintService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class DeviceInfoManager {
    private static Context context;
    private static DeviceInfoManager deviceInfoManager;
    private static TelephonyManager telephonyManager;
    private static ActivityManager activityManager;
    private static LocationManager locationManager;
    private static final String UNKNOWN = "n";
    private static final String KEY_DEVICE_ID = "device_id";

    private DeviceInfoManager() {
    }

    public static DeviceInfoManager getDeviceInfoManager(Context context) {
        if (deviceInfoManager == null) {
            DeviceInfoManager.context = context;
            telephonyManager = (TelephonyManager)context.getSystemService("phone");
            activityManager = (ActivityManager)context.getSystemService("activity");
            locationManager = (LocationManager)context.getSystemService("location");
            deviceInfoManager = new DeviceInfoManager();
        }
        return deviceInfoManager;
    }

    public DeviceInfoModel getDeviceInfo(Boolean isChecked) {
        DeviceInfoModel deviceInfoModel = new DeviceInfoModel();
        String mobileName = Build.MODEL;
        String mobileBrand = Build.BRAND;
        String ANDROID_ID = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        String osVersion = Build.VERSION.RELEASE;
        String deviceID = this.getDeviceId(telephonyManager.getDeviceId());
        String printerName = new PortParamDataBase(context).readPrinterName(GpPrintService.PrinterId);
        String uuid = UUID.randomUUID().toString();
        deviceInfoModel.setBrand(mobileBrand);
        deviceInfoModel.setMobileName(mobileName);
        deviceInfoModel.setAndroidId(ANDROID_ID);
        deviceInfoModel.setOsVersion(osVersion);
        deviceInfoModel.setDeviceId(deviceID);
        deviceInfoModel.setUuid(uuid);
        deviceInfoModel.setPrinter(printerName);
        if (isChecked.booleanValue()) {
            String ICCID = telephonyManager.getSimSerialNumber();
            String macAddress = this.getMacAddress();
            String ipAddress = this.getIpAddress();
            String upTime = this.getTimes();
            int allAppNum = this.getNumberOfApp();
            int installedAppNum = this.getNumberOfAppWithoutSystemApp();
            String installedApp = this.getNameOfInstalledApp();
            Date dateTime = new Date();
            deviceInfoModel.setIccid(ICCID);
            deviceInfoModel.setMacAddress(macAddress);
            deviceInfoModel.setIpAddress(ipAddress);
            deviceInfoModel.setUpTime(upTime);
            deviceInfoModel.setInstalledAppNum(installedAppNum);
            deviceInfoModel.setInstalledApp(installedApp);
            deviceInfoModel.setDateTime(dateTime);
        } else {
            Date dateTime = new Date();
            String deviceId = telephonyManager.getDeviceId();
            deviceInfoModel.setDeviceId(deviceId);
            deviceInfoModel.setDateTime(dateTime);
        }
        return deviceInfoModel;
    }

    public DataInfoModel getDataInfo() {
        DataInfoModel dataInfoModel = new DataInfoModel();
        Date dateTime = new Date();
        int systemAvaialbeMem = this.getSystemAvaialbeMemorySize();
        int memRate = this.getMemRate();
        int appMem = this.getAppMem();
        double processCpuRate = this.getProcessCpuRate();
        dataInfoModel.setDateTime(dateTime);
        dataInfoModel.setSystemAvailableMem(systemAvaialbeMem);
        dataInfoModel.setMemRate(memRate);
        dataInfoModel.setAppMem(appMem);
        dataInfoModel.setProcessCpuRate(processCpuRate);
        return dataInfoModel;
    }

    private int getNumberOfApp() {
        PackageManager pm = context.getPackageManager();
        List applicationInfos = pm.getInstalledApplications(8192);
        return applicationInfos.size();
    }

    private int getNumberOfAppWithoutSystemApp() {
        int numberOfApp = 0;
        PackageManager pm = context.getPackageManager();
        List applicationInfos = pm.getInstalledApplications(8192);
        for (ApplicationInfo appInfo : applicationInfos) {
            if ((appInfo.flags & 1) != 0) continue;
            ++numberOfApp;
        }
        return numberOfApp;
    }

    private String getNameOfInstalledApp() {
        StringBuilder builder = new StringBuilder();
        PackageManager pm = context.getPackageManager();
        List applicationInfos = pm.getInstalledApplications(8192);
        for (ApplicationInfo appInfo : applicationInfos) {
            if ((appInfo.flags & 1) != 0) continue;
            String str = appInfo.loadLabel(pm).toString();
            builder.append(String.valueOf(str) + ",");
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private String getBtMacAddress() {
        String macAddress = null;
        macAddress = BluetoothAdapter.getDefaultAdapter().getAddress();
        return macAddress;
    }

    private String getMacAddress() {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        String macAddress = wifiInfo.getMacAddress() != null ? wifiInfo.getMacAddress() : "Fail";
        return macAddress;
    }

    private String getIpAddress() {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (!wifiManager.isWifiEnabled()) {
            return "\u672a\u5f00\u542fwifi";
        }
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        int ipAddress = wifiInfo.getIpAddress();
        String ip = this.intToIp(ipAddress);
        return ip;
    }

    private String intToIp(int i) {
        return String.valueOf(i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    private String getTimes() {
        long ut = SystemClock.elapsedRealtime() / 1000L;
        if (ut == 0L) {
            ut = 1L;
        }
        int m = (int)(ut / 60L % 60L);
        int h = (int)(ut / 3600L);
        return String.valueOf(h) + "h" + m + "m";
    }

    private int getAppMem() {
        int uid = Process.myUid();
        int memSize = 0;
        for (ActivityManager.RunningAppProcessInfo appProcess : activityManager.getRunningAppProcesses()) {
            if (appProcess.uid != uid) continue;
            int[] pid = new int[]{appProcess.pid};
            Debug.MemoryInfo[] memoryInfo = activityManager.getProcessMemoryInfo(pid);
            memSize = memoryInfo[0].dalvikPrivateDirty + memSize;
        }
        return memSize;
    }

    private int getSystemAvaialbeMemorySize() {
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        long memSize = memoryInfo.availMem;
        int i = (int)memSize / 0x100000;
        return i;
    }

    private int getMemRate() {
        try {
            char[] cs;
            File file = new File("/proc/meminfo");
            FileInputStream fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String totalRam = br.readLine();
            br.close();
            StringBuffer sb = new StringBuffer();
            char[] cArray = cs = totalRam.toCharArray();
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (c >= '0' && c <= '9') {
                    sb.append(c);
                }
                ++n2;
            }
            int totalMem = (int)(Long.parseLong(sb.toString()) * 1024L) / 0x100000;
            int availableMem = this.getSystemAvaialbeMemorySize();
            int rate = 100 * (totalMem - availableMem) / totalMem;
            return rate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private double getProcessCpuRate() {
        float totalCpuTime1 = this.getTotalCpuTime();
        float processCpuTime1 = this.getAppCpuTime();
        try {
            Thread.sleep(360L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        float totalCpuTime2 = this.getTotalCpuTime();
        float processCpuTime2 = this.getAppCpuTime();
        float cpuRate = 100.0f * (processCpuTime2 - processCpuTime1) / (totalCpuTime2 - totalCpuTime1);
        BigDecimal b = new BigDecimal(cpuRate);
        double f = b.setScale(2, 4).doubleValue();
        return f;
    }

    private long getTotalCpuTime() {
        String[] cpuInfos = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        long totalCpu = Long.parseLong((String)cpuInfos[2]) + Long.parseLong((String)cpuInfos[3]) + Long.parseLong((String)cpuInfos[4]) + Long.parseLong(cpuInfos[6]) + Long.parseLong(cpuInfos[5]) + Long.parseLong(cpuInfos[7]) + Long.parseLong(cpuInfos[8]);
        return totalCpu;
    }

    private long getAppCpuTime() {
        String[] cpuInfos = null;
        try {
            int pid = Process.myPid();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + pid + "/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        long appCpuTime = Long.parseLong((String)cpuInfos[13]) + Long.parseLong((String)cpuInfos[14]) + Long.parseLong((String)cpuInfos[15]) + Long.parseLong((String)cpuInfos[16]);
        return appCpuTime;
    }

    private String getDeviceId(String deviceId) {
        if (deviceId == null) {
            String macAddr = this.getMacAddress().replaceAll(":", "");
            if (macAddr.equals("Fail") && TextUtils.isEmpty((CharSequence)(macAddr = this.getBtMacAddress()))) {
                SharedPreferences sharedPreference = context.getSharedPreferences(KEY_DEVICE_ID, 0);
                deviceId = sharedPreference.getString(KEY_DEVICE_ID, deviceId);
                if (TextUtils.isEmpty((CharSequence)deviceId)) {
                    long randomNum = (long)(Math.random() * 1.0E15 + 1.0);
                    deviceId = String.valueOf(randomNum);
                    sharedPreference.edit().putString(KEY_DEVICE_ID, deviceId).commit();
                }
                return deviceId;
            }
            String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            deviceId = String.valueOf(macAddr) + androidId.substring(androidId.length() - 3, androidId.length());
        }
        return deviceId;
    }

    private String getLocation() {
        Location location = locationManager.getLastKnownLocation("gps");
        double longtitude = location.getLongitude();
        double latitude = location.getLatitude();
        return String.valueOf(longtitude) + "," + latitude;
    }
}

